/*
 * Decompiled with CFR 0.152.
 */
package glodblock.com.github.handlers;

import com.google.common.collect.BiMap;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class HandlerOilVein {
    public static HashMap<String, short[]> fluidMap = new HashMap();

    public static void init() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            int color = fluid.getColor();
            if (color == -1) {
                fluidMap.put(fluid.getName(), HandlerOilVein.getColour(fluid));
                continue;
            }
            fluidMap.put(fluid.getName(), new short[]{(short)(color >> 16 & 0xFF), (short)(color >> 8 & 0xFF), (short)(color & 0xFF)});
        }
    }

    public static int getFluidID(Fluid fluid) {
        return (Integer)FluidRegistry.getRegisteredFluidIDs().get(fluid);
    }

    public static Fluid getFluid(int id) {
        return (Fluid)((BiMap)FluidRegistry.getRegisteredFluidIDs()).inverse().get((Object)id);
    }

    public static int getFluidID(String name) {
        Fluid fluid = FluidRegistry.getFluid((String)name);
        return HandlerOilVein.getFluidID(fluid);
    }

    private static short[] getColour(Fluid fluid) {
        short[] rgb = new short[3];
        try {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStill().toString());
            if (sprite == null) break block6;
            if (sprite.func_110970_k() <= 0) break block7;
            int[][] image = sprite.func_147965_a(0);
            int r = 0;
            int g = 0;
            int b = 0;
            int count = 0;
            int[][] nArray = image;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] row;
                for (int pixel : row = nArray[i]) {
                    if ((pixel >> 24 & 0xFF) <= 127) continue;
                    r += pixel >> 16 & 0xFF;
                    g += pixel >> 8 & 0xFF;
                    b += pixel & 0xFF;
                    ++count;
                }
            }
            if (count > 0) {
                rgb[0] = (short)(r / count);
                rgb[1] = (short)(g / count);
                rgb[2] = (short)(b / count);
            }
        }
        finally {
            return rgb;
        }
        {
            block6: {
                block7: {
                }
            }
        }
    }
}

